﻿/*	VERSION: 	1.0

USAGE: 
	#include "functions/addDragEvents.as"
	addDragEvents( myClip, 2 );
	react.to( "onDragStart" ).then = function( evt ){}
	react.to( "onDragMove" ).then = function( evt ){}
	react.to( "onDragEnd" ).then = function( evt ){}

WHAT IS THIS: 
	This is a general-purpose drag system that emits events when dragging starts and ends.
	The events occur within the movieClip specified for collision.
	
WARNING: 
	This applies  addMouseEvents.as  to the specified movieClip,  which will over-write ALL of its default mouse functions such as  onPress()
	This is done in order to fire corresponding mouse events such as "onPress"
	
EVENTS: 
	unload
	onDragStart			{ dragStart, dragEnd, dragOffset }		Fires at the moment a pressed-mouse has been dragged far enough to exceed the dragThreshold
	onDragMove			{ dragStart, dragEnd, dragOffset }		Fires each time the mouse moves after exceeding the dragThreshold
	onDragEnd				{ dragStart, dragEnd, dragOffset }		Fires at the moment the mouse is released during dragging
	
MOUSE EVENTS: 
	onDragOut
	onDragOver
	onMouseMove
	onPress
	onRelease
	onReleaseOutside
	onRollOut
	onRollOver
*/

// STANDARDIZED DRAG SYSTEM
function addDragEvents( _this, dragThreshold ){
	if( !_this )		_this = this;
	if( _this instanceof MovieClip  === false ){
		throw new Error('addDragEvents()  "_this" parameter is not a MovieClip.');
		return;
	}
	
	if( dragThreshold === undefined )		var dragThreshold = 2;
	
	var addMouseEvents;			// bind this function to the local scope
	#include "eventSystem3.as"
	#include "hitClip.as"
	#include "addMouseEvents.as"
	
	
	addMouseEvents( _this );
	
	
	
	// REACT event system
	if( !_this.addListener )		AsBroadcaster.initialize( _this );
	if( _this.react )						var react = _this.react;
	if( !react ){
		var react = make_react( _this );		// param is optional
		var old_onUnload = _this.onUnload;
		_this.onUnload = function(){
			sendEvent( "unload", null, _this );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
			old_onUnload();
		}// onUnload()
	}// react doesn't exist
	
	
	
	var isPressed = false;
	var isDragging = false;
	var dragStart = new flash.geom.Point();
	var dragOffset = new flash.geom.Point();
	
	
	
	// press
	react.to("onPress").from(_this).then = function()	{
		var hitResult = hitClip( {x:_root._xmouse,y:_root._ymouse}, _this );
		if(  !hitResult  )		return;
		isPressed = true;
		isDragging = false;
		dragStart = new flash.geom.Point( _this._xmouse, _this._ymouse );
		dragEnd = dragStart.clone();
		dragOffset = new flash.geom.Point( 0, 0 );
	}// onPress()
	
	
	
	// drag
	react.to("onMouseMove").from(_this).then = function()	{
		if( !isPressed )		return;
		
		var dragEnd = new flash.geom.Point( _this._xmouse, _this._ymouse );
		if( !isDragging )
		{// if:   not dragging yet
			var distance = flash.geom.Point.distance( dragStart, dragEnd );
			if( distance > dragThreshold)
			{// if:  dragging has just begin
				isDragging = true;
				dragOffset = dragStart.subtract( dragEnd );
				sendEvent("onDragStart", {
					dragStart: dragStart, 
					dragEnd: dragEnd, 
					dragOffset: dragOffset
				}, _this);
			}// if:  dragging has just begin
		}// if:   not dragging yet
		
		if( isDragging )
		{// if:  is dragging
			sendEvent("onDragMove", {
				dragStart: dragStart, 
				dragEnd: dragEnd, 
				dragOffset: dragOffset
			}, _this);
		}// if:  is dragging
		
	}// onMouseMove()
	
	
	
	// release
	var react_to_onRelease = react.to("onRelease").from(_this);
	react_to_onRelease.then = function()	{
		if( !isPressed )		return;		//  ignore releases that don't have a corresponding onPress
		var leftClick_key = 1;
		var mouseIsDown = Key.isDown( leftClick_key );
		if( mouseIsDown )		return;		//  mouse was not actually released  ( Can be caused by new movieClips being created under the mouse ( for overlays )
		
		isPressed = false;
		isDragging = false;
		
		var dragEnd = new flash.geom.Point( _this._xmouse, _this._ymouse );
		
		sendEvent("onDragEnd", {
			dragStart: dragStart, 
			dragEnd: dragEnd, 
			dragOffset: dragOffset
		}, _this);
	}// onRelease()
	
	
	
	// release
	react.to("onReleaseOutside").from(_this).then = react_to_onRelease.then;
}// addDragEvents()